  rem - xmastree.bas - 12/21/96
  rem - version 1.04

$CPU 8086                 ' program works on any CPU

$LIB COM        OFF       ' turn off PowerBASIC's communications library.

$COM    0                 ' set communications buffer to nothing
$STACK  2048              ' let's use a 2k stack
$SOUND  1                 ' smallest music buffer possible

$DIM ARRAY                ' force arrays to be pre-dimensioned before they
                          ' can be used

DEFINT A-Z                ' default all variables to integers for maximum
                          ' speed and minimum size

  %maxcols = 640
  %maxrows = 480

  %maxcols_minus1 = %maxcols - 1
  %maxcols_plus1 = %maxcols + 1
  %maxrows_minus1 = %maxrows - 1
  %maxrows_minus2 = %maxrows - 2
  %maxsnowarray = (%maxcols \ 16) * %maxrows - 1
  %rowcenter = %maxcols \ 2

  DIM across(299), down(299), circlex(72), circley(72), palcolor(15)
  DIM DYNAMIC falling_snow(%maxsnowarray)

Begin:
  SCREEN 0
  CLS
  PRINT "Xmas Tree"; TAB (34); "version 1.04"; TAB (68); "21 Dec 1996"
  PRINT
  PRINT "It's December in snow country.  The holidays are approaching."
  PRINT "Standing alone at the top of a hill is a tall evergreen tree."
  PRINT "Someone has decorated it with lighted spheres that change color."
  PRINT "And it looks like it's about to start snowing..."
  PRINT
  PRINT "The display will begin in one minute (or after you press any key)."
  PRINT
  PRINT "Once the snowflakes start falling, the following commands are";
  PRINT " valid:"
  PRINT "  b - change the Ball colors";
  PRINT TAB (40); "  q - Quit the program"
  PRINT "  f - Freeze/unfreeze the screen";
  PRINT TAB (40); "  r - Restart the program"
  PRINT "  n - start a New display";
  PRINT TAB (40); "  t - change the Tree colors"
  PRINT
  PRINT
  PRINT "Original code by: D. Smith"
  PRINT "                  Mentor College"
  PRINT "                  Toronto, Canada"
  PRINT "                  nanook@interlog.com"
  PRINT
  PRINT "Modified and expanded by: Bob Ellis"
  PRINT "                          rellis@voicenet.com"
  PRINT "                          http://www.voicenet.com/~rellis/"

  a1! = TIMER
  DO
    a2! = TIMER
    IF a2! < a1! THEN INCR A2!, 86400
    IF a2! > a1! + 60! THEN EXIT LOOP
  LOOP UNTIL INKEY$ <> ""

  SCREEN 12

  ballradius = 5  ' y-axis radius of ball in pixels
  blinkrate = 3000  ' the larger this value, the slower the balls blink
  maxflakes = 300  ' maximum number of snowflakes on screen
  donechecklimit = maxflakes * %maxrows / blinkrate
  snowlimit = 11  ' restart display when snow is up to this y-axis pixel

  RANDOMIZE TIMER  ' make it different each time

Restart:
  LINE (0, 0) - (%maxcols_minus1, %maxrows_minus1), 0, BF  ' clear the screen
  screen_frozen = 0

  ERASE falling_snow
  DIM DYNAMIC falling_snow(%maxsnowarray)

    rem - set up palette

  CALL SetTreeColors (2)  ' tree colors
  CALL SetBallColors      ' ball colors

    rem - draw tree in 7 colors

  FOR j = 1 TO 15
    FOR i = 10 TO %maxrows_minus1
      LINE (320,i)-STEP (INT (RND * i / 2), CEIL (RND * i)), CEIL (RND * 7)
      LINE (320,i)-STEP (-INT (RND * i / 2), CEIL (RND * i)), CEIL (RND * 7)
    NEXT i
  NEXT j

  adjust1 = %rowcenter - %maxrows \ 2
  FOR i = 1 TO (%maxrows \ 4) * (%maxrows \ 8)
    across1 = adjust1 + INT (RND * %maxrows)
    down1 = INT (RND * %maxrows)
    DO
      FOR j = across1 - 1 TO across1 + 1
        FOR k = down1 - 1 TO down1 + 1
          SELECT CASE POINT (j, k)
            CASE <1, >7
              EXIT LOOP
          END SELECT
        NEXT k
      NEXT j
      PSET (across1, down1), 0
      EXIT LOOP
    LOOP
  NEXT i

    rem - put colored balls on tree

  numcircles = 0
  FOR i = 0 TO 5
    i1 = 320 - i * 39
    i2 = 320 + i * 39
    FOR j = i1 TO i2 STEP 78
      IF i1 = i2 THEN
        j1 = 2
      ELSEIF j = i1 OR j = i2 THEN
        j1 = 3
      ELSE
        j1 = 4
      END IF
      FOR k = 1 TO j1
        DO
          DO
            y = i * 78 + INT (RND * 78) + 10
            x = j + INT (RND * 78) - 39
          LOOP WHILE POINT (x, y) = 0
          FOR k1 = 1 TO numcircles
            IF ABS (x - circlex(k1)) < ballradius * 8 / 3 + 2 THEN
              IF ABS (y - circley(k1)) < ballradius * 2 + 2 THEN ITERATE DO
            END IF
          NEXT k1
          EXIT LOOP
        LOOP
        INCR numcircles
        circley(numcircles) = y
        circlex(numcircles) = x
        ballcolor = CEIL (RND * 7) + 7
        CIRCLE (x, y), ballradius, ballcolor
        PAINT STEP (0, 0), ballcolor
      NEXT k
    NEXT j
  NEXT i

    rem - create/animate snowflakes

  blinkcount = 0
  curflakes = 1
  down(0) = 0
  donecheck = 0
  curkey$ = ""
  maxdown = 0
  flake_switch1 = 0
  flake_switch2 = 0
  flake_switch2_max = 3

  WHILE INKEY$ <> "" : WEND

  DO

    IF INSTAT THEN
      oldkey$ = curkey$
      curkey$ = LCASE$ (INKEY$)
      SELECT CASE LCASE$ (curkey$)
        CASE "b"  ' change the ball color palette entries
          CALL SetBallColors
        CASE "f"  ' freeze/unfreeze the screen
          IF screen_frozen THEN screen_frozen = 0 ELSE screen_frozen = -1
        CASE "n"  ' new display
          GOTO Restart
        CASE "q"  'quit the program
          EXIT LOOP
        CASE "r"  ' restart the program
          GOTO Begin
        CASE "t"  ' change the tree color palette entries
          old_base_color = tree_base_color
          CALL SetTreeColors (-1)
          IF old_base_color <> tree_base_color THEN CALL SetBallColors
        CASE ELSE
          IF oldkey$ = "?" THEN curkey$ = " " : EXIT SELECT
          SOUND 800, 2
          DIM save_scrn_1 (10369)
          GET (64, 48) - (351, 191), save_scrn_1
          LINE (64, 48) - (351, 191), 0, BF
          LINE (64, 48) - (351, 191), 15, B
          LINE (66, 50) - (349, 189), 15, B
          COLOR 15
          LOCATE 5, 11
          PRINT "Valid commands:";
          LOCATE 6, 13
          PRINT "b - change the Ball colors";
          LOCATE 7, 13
          PRINT "f - Freeze/unfreeze the screen";
          LOCATE 8, 13
          PRINT "n - start a New display";
          LOCATE 9, 13
          PRINT "q - Quit the program";
          LOCATE 10, 13
          PRINT "r - Restart the program";
          LOCATE 11, 13
          PRINT "t - change the Tree colors";
          curkey$ = "?"
          WHILE NOT INSTAT : WEND
          PUT (64, 48), save_scrn_1, PSET
          ITERATE DO
      END SELECT
      IF screen_frozen THEN
        WHILE NOT INSTAT : WEND
        ITERATE DO
      END IF
    END IF

    INCR blinkcount
    IF blinkcount >= blinkrate THEN  ' change a ball's color
      blinkcount = 0
      ballcolor = CEIL (RND * 7) + 7
      ballnum = CEIL (RND * numcircles)
      CIRCLE (circlex(ballnum), circley(ballnum)), ballradius, ballcolor
      PAINT STEP(0, 0), ballcolor
      IF curflakes >= maxflakes THEN
        INCR donecheck
        IF donecheck >= donechecklimit THEN
          IF maxdown < snowlimit THEN Restart
          donecheck = 0
          maxdown = 0
        END IF
      END IF
    END IF

    f = INT (RND * maxflakes)
    IF f >= curflakes THEN ITERATE DO

    down1 = down(f)
    SELECT CASE down1
      CASE < 0
        INCR down(f)
        ITERATE DO
      CASE 0
        across(f) = INT (RND * %maxcols)
      CASE ELSE
        IF maxdown < down1 THEN maxdown = down1
    END SELECT

    across1 = across(f)
    SnowFlakeBit& = GetSnowFlakeBit& (across1, down1)

    down_center = POINT (across1, down1 + 1)
    SELECT CASE down_center

    CASE <= 0  ' no color below
      PSET (across1, down1), 0
      BIT RESET falling_snow(0), SnowFlakeBit&
      INCR down(f)
      PSET (across1, down(f)), 15
      IF down(f) > %maxrows_minus2 THEN
        down(f) = 0
      ELSE
        BIT SET falling_snow(0), SnowFlakeBit& + %maxcols
      END IF

    CASE ELSE  ' something below
      IF down_center <> 15 THEN  ' it's not a flake
        INCR flake_switch2
        IF flake_switch2 >= flake_switch2_max THEN
          flake_switch2 = 0
          IF RedirectFlake% = 1 THEN
            PSET (across1, down1), 0
            BIT RESET falling_snow(0), SnowFlakeBit&
            EXIT SELECT
          END IF
        END IF
      ELSE  ' flake below
        FOR i = down1 + 2 TO %maxrows_minus1
          IF POINT (across1, i) <> 15 THEN
            IF i < (down1 + 3) THEN EXIT FOR
            IF RedirectFlake% = 0 THEN EXIT FOR
            PSET (across1, down1), 0
            BIT RESET falling_snow(0), SnowFlakeBit&
            EXIT SELECT
          END IF
        NEXT i
      END IF
      c$ = ""
      down_right = POINT (across1 + 1, down1 + 1)
      IF down_right = 0 THEN c$ = "R"
      down_left = POINT (across1 - 1, down1 + 1)
      IF down_left = 0 THEN c$ = c$ + "L"

      SELECT CASE c$

      CASE ""  ' can't go lower
        BIT RESET falling_snow(0), SnowFlakeBit&
        setflake1 = 0
        INCR SnowFlakeBit&, %maxcols_minus1
        DO
          IF across1 > 0 THEN
            IF BIT (falling_snow(0), SnowFlakeBit&) = 1 THEN EXIT LOOP
          END IF
          INCR SnowFlakeBit&
          IF BIT (falling_snow(0), SnowFlakeBit&) = 1 THEN EXIT LOOP
          INCR SnowFlakeBit&
          IF across1 < %maxcols_minus1 THEN
            IF BIT (falling_snow(0), SnowFlakeBit&) = 1 THEN EXIT LOOP
          END IF
          setflake1 = 15
          EXIT LOOP
        LOOP
        PSET (across1, down1), setflake1
        IF setflake1 = 0 THEN IF RedirectFlake% = 1 THEN EXIT SELECT
        GOSUB RecycleFlake

      CASE "R"  ' go down to the right
        PSET (across1, down1), 0
        BIT RESET falling_snow(0), SnowFlakeBit&
        IF down_left = 15 THEN
          IF down_center = 15 THEN
            INCR flake_switch2
            IF flake_switch2 >= flake_switch2_max THEN
              flake_switch2 = 0
              IF RedirectFlake% = 1 THEN EXIT SELECT
              IF across1 > %rowcenter THEN
                GOSUB RecycleFlake
                EXIT SELECT
              END IF
            END IF
          END IF
        END IF
        INCR down(f)
        INCR across(f)
        PSET (across(f), down(f)), 15
        IF down(f) > %maxrows_minus2 THEN
          down(f) = 0
        ELSE
          BIT SET falling_snow(0), SnowFlakeBit& + %maxcols_plus1
        END IF

      CASE "L"  ' go down to the left
        PSET (across1, down1), 0
        BIT RESET falling_snow(0), SnowFlakeBit&
        IF down_right = 15 THEN
          IF down_center = 15 THEN
            INCR flake_switch2
            IF flake_switch2 >= flake_switch2_max THEN
              flake_switch2 = 0
              IF RedirectFlake% = 1 THEN EXIT SELECT
              IF across1 < %rowcenter THEN
                GOSUB RecycleFlake
                EXIT SELECT
              END IF
            END IF
          END IF
        END IF
        INCR down(f)
        DECR across(f)
        PSET (across(f), down(f)), 15
        IF down(f) > %maxrows_minus2 THEN
          down(f) = 0
        ELSE
          BIT SET falling_snow(0), SnowFlakeBit& + %maxcols_minus1
        END IF

      CASE "RL"  ' can go down to the left or the right
        PSET (across1, down1), 0
        BIT RESET falling_snow(0), SnowFlakeBit&
        IF down_center = 15 THEN
          INCR flake_switch2
          IF flake_switch2 >= flake_switch2_max THEN
            flake_switch2 = 0
            IF RedirectFlake% = 1 THEN EXIT SELECT
          END IF
        END IF
        a = INT (RND * 2)
        IF a = 0 THEN a = -1
        INCR down(f)
        INCR across(f), a
        PSET (across(f), down(f)), 15
        IF down(f) > %maxrows_minus2 THEN
          down(f) = 0
        ELSE
          BIT SET falling_snow(0), SnowFlakeBit& + %maxcols + a
        END IF

      END SELECT

    END SELECT

  LOOP

  END

RecycleFlake:
  DECR down(f), %maxrows_minus2
  IF curflakes < maxflakes THEN
    down(curflakes) = 0
    INCR curflakes
  END IF
  RETURN

FUNCTION GetSnowFlakeBit& (col1, row1) LOCAL PRIVATE
  FUNCTION = row1 * %maxcols + col1
END FUNCTION

FUNCTION RedirectFlake% SHARED PRIVATE
'  IF flake_switch1 = 0 THEN
'    flake_switch1 = 1
    FOR j = down1 + 2 TO %maxrows_minus2
      IF POINT (across1, j) = 0 THEN
        PSET (across1, j), 15
        down(f) = j
        BIT SET falling_snow(0), GetSnowFlakeBit& (across1, j)
        FUNCTION = 1
        EXIT FUNCTION
      END IF
    NEXT j
'  ELSE
'    flake_switch1 = 0
'    FOR j = %maxrows_minus2 TO down1 + 2 STEP -1
'      IF POINT (across1, j) = 0 THEN
'        FOR j1 = j - 1 TO 0 STEP -1
'          IF POINT (across1, j1) > 0 THEN EXIT FOR
'        NEXT j1
'        INCR j1
'        PSET (across1, j1), 15
'        down(f) = j1
'        BIT SET falling_snow(0), GetSnowFlakeBit& (across1, j1)
'        FUNCTION = 1
'        EXIT FUNCTION
'      END IF
'    NEXT j
'  END IF
  FUNCTION = 0
END FUNCTION

SUB SetBallColors LOCAL PRIVATE
  SHARED palcolor(), tree_base_color
  FOR i = 8 TO 14
    DO
      DO
        color1 = CEIL (RND * 62)
        SELECT CASE color1 MOD 8
          CASE 0, tree_base_color
            ITERATE DO
        END SELECT
        color2 = color1 \ 8
        IF color2 = 7 THEN EXIT LOOP
        IF (color2 AND tree_base_color) <> tree_base_color THEN EXIT LOOP
      LOOP
      FOR j = 8 TO i - 1  ' insure all colors are different
        IF color1 = palcolor(j) THEN ITERATE DO
      NEXT j
      EXIT LOOP
    LOOP
    palcolor(i) = color1
    PALETTE i, color1
  NEXT i
END SUB

SUB SetTreeColors (BYVAL opt1) LOCAL PRIVATE
  SHARED palcolor(), tree_base_color
  SELECT CASE opt1
    CASE 0 TO 7
      tree_base_color = opt1
    CASE ELSE
      tree_base_color = 2 ^ INT (RND * 3)
  END SELECT
  FOR i = 1 TO 7  ' tree colors
    DO
      color1 = INT (RND * 8) * 8 + tree_base_color
      FOR j = 1 TO i - 1  ' insure all colors are different
        IF color1 = palcolor(j) THEN ITERATE DO
      NEXT j
      EXIT LOOP
    LOOP
    palcolor(i) = color1
    PALETTE i, color1
  NEXT i
END SUB
