  rem - SVGASUB1.BAS - 19 Jul 1996
  rem - Super VGA interrupt routines

$INCLUDE "example\regnames.bas"
$INCLUDE "mysubs\svgatyp1.bas"

FUNCTION Svga_F00?? (vesa00 AS Vesa12_VgaInfoBlock_type) LOCAL PUBLIC
'
'  VESA version 1.2; function 00h; get Super VGA information
'
  REG %AX, &H4f00
  REG %ES, VARSEG (vesa00)
  REG %DI, VARPTR (vesa00)
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F01?? (BYVAL getmode??, vesa01 AS Vesa12_ModeInfoBlock_type) _
 LOCAL PUBLIC
'
'  VESA version 1.2; function 01h; get Super VGA mode-specific info
'
  REG %AX, &H4f01
  REG %CX, getmode??
  REG %ES, VARSEG (vesa01)
  REG %DI, VARPTR (vesa01)
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F02?? (BYVAL setmode??) LOCAL PUBLIC
'
'  VESA version 1.2; function 02h; set Super VGA video mode
'
'  setmode?? contents:
'    D0-D14 = Video mode
'       D15 = Clear memory flag
'             0 = Clear video memory
'             1 = Don't clear video memory
'
  REG %AX, &H4f02
  REG %BX, setmode??
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F03?? (getmode??) LOCAL PUBLIC
'
'  VESA version 1.2; function 03h; return video mode
'
'  getmode?? contents:
'    D0-D14 = Video mode
'       D15 = 0
'
  REG %AX, &H4f03
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  getmode?? = REG (%BX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F04_00?? (BYVAL req_state??, buffer_blocks??) LOCAL PUBLIC
'
'  VESA version 1.2; function 04h, sub-function 00h; return save/restore
'    state buffer size
'
'  req_state?? = Requested states
'    D0 = Save/restore video hardware state
'    D1 = Save/restore video BIOS data state
'    D2 = Save/restore video DAC state
'    D3 = Save/restore Super VGA state
'
'  buffer_blocks?? = Number of 64-byte blocks to hold the state buffer
'
  REG %AX, &H4f04
  REG %CX, req_state??
  REG %DX, &H0000
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  buffer_blocks?? = REG (%BX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F04_01?? (BYVAL req_state??, BYVAL buffer_ptr AS DWORD) _
 LOCAL PUBLIC
'
'  VESA version 1.2; function 04h, sub-function 01h; save Super VGA state(s)
'
'  req_state?? = Requested states
'    D0 = Save video hardware state
'    D1 = Save video BIOS data state
'    D2 = Save video DAC state
'    D3 = Save Super VGA state
'
'  buffer_ptr must contain the buffer address in which to save the state(s)
'
  REG %AX, &H4f04
  REG %CX, req_state??
  REG %DX, &H0001
! les di, buffer_ptr
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F04_02?? (BYVAL req_state??, BYVAL buffer_ptr AS DWORD) _
 LOCAL PUBLIC
'
'  VESA version 1.2; function 04h, sub-function 02h; restore Super VGA
'   state(s)
'
'  req_state?? = Requested states
'    D0 = restore video hardware state
'    D1 = restore video BIOS data state
'    D2 = restore video DAC state
'    D3 = restore Super VGA state
'
'  buffer_ptr must contain the buffer address from which to restore the
'   state(s)
'
  REG %AX, &H4f04
  REG %CX, req_state??
  REG %DX, &H0002
! les di, buffer_ptr
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F05_00?? (BYVAL win_num?, BYVAL win_pos%) LOCAL PUBLIC
'
'  VESA version 1.2; function 05h, sub-function 00h; select Super VGA video
'   memory window
'
'  win_num? = Window number
'             0 = Window A
'             1 = Window B
'
'  win_pos% = Window position in video memory
'              (in window granularity units)
'
  REG %AX, &H4f05
  REG %BX, win_num?
  REG %DX, win_pos%
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

FUNCTION Svga_F05_01?? (BYVAL win_num?, win_pos%) LOCAL PUBLIC
'
'  VESA version 1.2; function 05h, sub-function 01h; return Super VGA video
'   memory window
'
'  win_num? = Window number
'             0 = Window A
'             1 = Window B
'
'  win_pos% = Window position in video memory
'              (in window granularity units)
'
  REG %AX, &H4f05
  REG %BX, 256% + win_num?
  CALL INTERRUPT &H10
  status1?? = REG (%AX)
  win_pos% = REG (%DX)
  IF status1?? = &H004f THEN
    FUNCTION = 0??
  ELSE
    FUNCTION = status1??
  END IF
END FUNCTION

'
'6.8             Function 06h - Set/Get Logical Scan Line Length
'
'This function sets or gets the length of a logical scan line.  This function
'allows an application to set up a logical video memory buffer that is wider than
'
'the displayed area.  Function 07h then allows the application to set the
'starting position that is to be displayed.
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 06h        Logical Scan Line Length
'                BL = 00h        Select Scan Line Length
'                CX = Desired width in pixels
'
'        Output: AX = Status
'                BX = Bytes Per Scan Line
'                CX = Actual Pixels Per Scan Line
'                DX = Maximum Number of Scan Lines
'
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 06h        Logical Scan Line Length
'                BL = 01h        Return Scan Line Length
'
'        Output: AX = Status
'                BX = Bytes Per Scan Line
'                CX = Actual Pixels Per Scan Line
'                DX = Maximum Number of Scan Lines
'
'Notes
'~~~~~
'The desired width in pixels may not be achieveable because of VGA hardware
'considerations.  The next larger value will be selected thta will accommodate
'the desired number of pixels, and the actual number of pixels will be returned
'in CX.  BX returns a value that, when added to a pointer into video memory, will
'
'point to the next scan line.  For example, in a mode 13h this would be 320, but
'in mode 12h this would be 80.  DX returns the number of logical scan lines based
'
'upon the new scan line length and the total memory installed and useable in this
'
'display mode.  This function is also valid in text modes.  In text modes, the
'application should find out the current character cell width through normal BIOS
'
'functions, multiply that times the desired number of characters per line, and
'pass the value in the CX register.
'
'
'6.9             Function 07h - Set/Get Display Start
'
'This function selects the pixel to be displayed in the upper left corner of the
'display from the logical page.  This function can be used to pan and scroll
'around logical screens that are larger than the displayed screen.  This function
'
'can also be used to rapidly switch between two different displayed screens for
'double buffered animation effects.
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 07h        Display Start Control
'                BH = 00h        Reserved and must be 0
'                BL = 00h        Select Display Start
'                CX = First Displayed Pixel in Scan Line
'                DX = First Displayed Scan Line
'
'        Output: AX = Status
'
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 07h        Display Start Control
'                BL = 01h        Return Display Start
'
'        Output: AX = Status
'                BH = 00h Reserved and will be 0
'                CX = First Displayed Pixel in Scan Line
'                DX = First Displayed Scan Line
'
'Notes
'~~~~~
'This function is also valid in text modes.  In text modes, the application
'should find out the current character cell width through normal BIOS functions,
'multiply that times the desired starting character column, and pass that value
'in the CX register.  It should also multiply the current character cell height
'times the desired starting character row, and pass that value in the DX
'register.
'
'
'6.10            Function 08h - Set/Get DAC Palette Control
'
'This function queries and selects the operating mode of the DAC palette.  Some
'DACs are configurable to provide 6-bits, 8-bits, or more of color definition per
'
'red, green, and blue primary color.  The DAC palette width is assumed to be
'reset to standard VGA 6-bits per primary during a standard or VESA Set Super VGA
'
'Mode (AX = 4F02h) call.
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 08h        Set/Get DAC Palette Control
'                BL = 00h        Set DAC palette width
'                BH = Desired number of bits of color per primary
'                     (Standard VGA = 6)
'
'        Output: AX = Status
'                BH = Current number of bits of color per primary
'                (Standard VGA = 6)
'
'
'        Input:  AH = 4Fh        Super VGA support
'                AL = 08h        Set/Get DAC Palette Control
'                BL = 01h        Get DAC palette width
'
'        Output: AX = Status
'                BH = Current number of bits of color per primary
'                (Standard VGA = 6)
'
'Notes
'~~~~~
'An application can find out if DAC switching is available by querying Bit D0 of
'the Capabilities field of the VgaInfoBlock structure returned by VESA Return
'Super VGA Information (AX = 4F00h).  The application can then attempt to set the
'
'DAC palette width to the desired value.  If the Super VGA is not capable of
'selecting the requested palette width, then the next lower value that the Super
'VGA is capable of will be selected.  The resulting palette width is returned.
