  rem - GIF4b.BAS - 12 Feb 97
  rem - Display GIF files

'PB GIF - converted from QBASIC source code to PowerBASIC
' by Dave Navarro, Jr.
'Modified to handle interlaced images, multiple images within a GIF,
' graphic control extension blocks, local color maps, multiple GIFs,
' scrolling, fading, animation, support for some 256 color SVGA modes,
' toggle to use/ignore transparency information, log contents of the
' file(s), . . .
' by Bob Ellis.
'  Email: rellis@voicenet.com
'  WWW:   http://www.voicenet.com/~rellis/
'Tested on PowerBASIC 3.20

$CPU 8086                 ' program works on any CPU

$OPTIMIZE SPEED           ' make fastest possible executable

$LIB COM        OFF       ' turn off PowerBASIC's communications library.

$FLOAT PROCEDURE          ' use procedural floating point to optimize for
                          ' machines without a co-processor

$COM    0                 ' set communications buffer to nothing
$STACK  2048              ' let's use a 2k stack
$SOUND  1                 ' smallest music buffer possible

$DIM ARRAY                ' force arrays to be pre-dimensioned before they can
                          ' be used

  DEFINT A-Z

  %default = 0
  %global = 1
  %local = 2
  %maxvideomode = 9
  %no = 0
  %off = 0
  %on = 1
  %yes = 1

$INCLUDE "mysubs/svgasub1.bas"

  DIM ByteBuffer AS STRING * 1
  DIM Prefix(4096), Suffix(4096), Outcode(1024), CodeMask(1:8)
  DIM MaxCodes(2:13), Powers2(0:14)

  TYPE VideoMode_type
    mode AS WORD
    Xresolution AS INTEGER
    Yresolution AS INTEGER
  END TYPE

  DIM ValidVideoMode(%maxvideomode) AS VideoMode_type
  ValidVideoMode(0).mode = &H0013
  ValidVideoMode(0).Xresolution = 320
  ValidVideoMode(0).Yresolution = 200
  lastvideomode = 0

  DIM WordPointer AS WORD PTR
  DIM vesa0 AS SHARED Vesa12_VgaInfoBlock_type
  DIM vesa1 AS SHARED Vesa12_ModeInfoBlock_type

  SHARED X, Xstart, Xend, Y, Ystart, Yend, y_start_offset, y_incr
  SHARED interlaced_image
  SHARED screen_Xmax, screen_Ymax
  SHARED win_read?, win_read_seg??, win_write?, win_write_seg??
  SHARED cur_win_base&, nxt_win_base&
  SHARED WindowSize&

  FOR i = 2 TO 13
    MaxCodes(i) = 2 ^ i
  NEXT i

  FOR i = 1 TO 8
    CodeMask(i) = (2 ^ i) -1
  NEXT i

  FOR i = 0 TO 14
    Powers2(i) = 2 ^ i
  NEXT i

Start1:
  CLS
  PRINT "GIF File Viewer version 4b"

  PRINT
  PRINT

  tempdir$ = ENVIRON$ ("TEMP")
  IF tempdir$ = "" THEN tempdir$ = ENVIRON$ ("TMP")
'  curdrive$ = LEFT$ (CURDIR$, 2)
'  ON ERROR GOTO FileNotFound
'  i = ATTRIB (curdrive$ + "\temp")
'  ON ERROR GOTO 0
'  IF BIT (i, 4) = 0 THEN
  IF tempdir$ = "" THEN
    global_dprint = %off
    PRINT "There is no 'TEMP' or 'TMP' environment variable to specify a directory in"
    PRINT " which to log information about any GIF files you choose to view."
    PRINT
    PRINT "Logging mode has been turned off."
  ELSE
    PRINT "  -----  WARNING  -----  WARNING  -----  WARNING  -----  WARNING  -----"
    PRINT
    PRINT "This program will attempt to create/append to the file '";
    PRINT tempdir$; "\$gifinfo.log'"
    PRINT " to store data about any GIF files you choose to view."
    PRINT
    PRINT "THIS FILE WILL CONTINUE TO GROW UNTIL YOU MANUALLY DELETE IT!"
    PRINT
    PRINT "Is this OK (Y/N)? ";
    col1 = POS
    LOCATE , , 1
    DO
      a$ = INKEY$
      SELECT CASE a$
        CASE "Y", "y"
          PRINT a$
          global_dprint = %on
          PRINT
          PRINT "Logging mode has been turned on."
          EXIT LOOP
        CASE "N", "n"
          PRINT a$
          global_dprint = %off
          PRINT
          PRINT "Logging mode has been turned off."
          EXIT LOOP
        CASE <> ""
          PRINT a$;
          BEEP
          LOCATE , col1
      END SELECT
    LOOP
  END IF

  PRINT
  CALL PressAnyKey

  PRINT
  PRINT

CheckForSvga:
  IF Svga_F00?? (vesa0) <> 0 THEN
    PRINT "No SVGA support."
    GOTO MustUseVga
  END IF
  IF Svga_F03?? (video_mode_0??) <> 0 THEN
    PRINT "Cannot ascertain current video mode from SVGA function 03h."
    GOTO MustUseVga
  END IF
  IF vesa0.VESASignature <> "VESA" THEN
    PRINT "Invalid VESA Signature - "; vesa0.VesaSignature
    GOTO MustUseVga
  END IF
  IF vesa0.VesaVersion < 258 THEN
    PRINT "VESA version"; STR$ (vesa0.VesaVersion \ 256); "."; _
     LTRIM$ (STR$ (vesa0.VESAVersion MOD 256) ); _
     " is below 1.2 - not supported."
    GOTO MustUseVga
  END IF
  win_read? = 255
  win_write? = 255
  IF vesa0.VideoModePtr <> 0 THEN
    WordPointer = vesa0.VideoModePtr
    WHILE @WordPointer <> &H0ffff
      PRINT "Checking video mode "; HEX$ (@WordPointer); ": ";
      i = ChkVideoModes% (@WordPointer)
      IF i = 0 THEN
        PRINT "acceptable"
        IF lastvideomode < %maxvideomode THEN
          INCR lastvideomode
          ValidVideoMode(lastvideomode).mode = @WordPointer
          ValidVideoMode(lastvideomode).Xresolution = vesa1.XResolution
          ValidVideoMode(lastvideomode).Yresolution = vesa1.YResolution
        END IF
      END IF
      INCR WordPointer, 2
    WEND
  END IF
  IF lastvideomode > 0 THEN GotDisplayModes

MustUseVga:
  video_mode_1?? = &H0013
  REG %AX, &H0f00
  CALL INTERRUPT &H10
  video_mode_0?? = REG (%AX) AND &H00ff

GotDisplayModes:
  PRINT
  PRINT "Current video mode is "; HEX$ (video_mode_0??); "h"
  PRINT
  CALL PressAnyKey

'
'                Graphics Interchange Format Data Definition
'
'      "The Graphics Interchange Format(c) is the Copyright property of
'      CompuServe Incorporated.  GIF(sm) is a Service Mark property of
'      CompuServe Incorporated."
'
'
' GENERAL FILE FORMAT
'
'        +-------------------------------+
'        | +---------------------------+ |
'        | |   GIF Signature           | |
'        | +---------------------------+ |
'        | +---------------------------+ |
'        | | Logical Screen Descriptor | |
'        | +---------------------------+ |
'        | +---------------------------+ |
'        | | Global Color Map          | |
'        | +---------------------------+ |
'        . . .                       . . .
'        | +---------------------------+ |    ---+
'        | |  Image Descriptor         | |       |
'        | +---------------------------+ |       |
'        | +---------------------------+ |       |
'        | |  Local Color Map          | |       |-   Repeated 1 to n times
'        | +---------------------------+ |       |
'        | +---------------------------+ |       |
'        | |    Raster Data            | |       |
'        | +---------------------------+ |    ---+
'        . . .                       . . .
'        |-    GIF Terminator           -|
'        +-------------------------------+
'
'
' GIF SIGNATURE
'
'         7 6 5 4 3 2 1 0        Field Name                 Type
'        +---------------+
'      0 |               |       Signature                  3 Bytes
'        +-             -+
'      1 |               |
'        +-             -+
'      2 |               |
'        +---------------+
'      3 |               |       Version                    3 Bytes
'        +-             -+
'      4 |               |
'        +-             -+
'      5 |               |
'        +---------------+
'
'     i) Signature - Identifies the GIF Data Stream. This field contains
'        the fixed value 'GIF'.
'
'     ii) Version - Version number used to format the data stream.
'         Identifies the minimum set of capabilities necessary to a decoder
'         to fully process the contents of the Data Stream.
'
'         Version Numbers as of 10 July 1990 :       "87a" - May 1987
'                                                    "89a" - July 1989
'
'
' LOGICAL SCREEN DESCRIPTOR
'
'        The Logical Screen Descriptor contains the parameters
'   necessary to define the area of the display device within which the
'   images will be rendered.  The coordinates in this block are given with
'   respect to the top-left corner of the virtual screen; they do not
'   necessarily refer to absolute coordinates on the display device.  This
'   implies that they could refer to window coordinates in a window-based
'   environment or printer coordinates when a printer is used.
'
'        This block is REQUIRED; exactly one Logical Screen Descriptor must
'   be present per Data Stream.
'
'          7 6 5 4 3 2 1 0        Field Name                    Type
'         +---------------+
'      0  |               |       Logical Screen Width          Unsigned
'         +-             -+
'      1  |               |
'         +---------------+
'      2  |               |       Logical Screen Height         Unsigned
'         +-             -+
'      3  |               |
'         +---------------+
'      4  | |     | |     |       <Packed Fields>               See below
'         +---------------+
'      5  |               |       Background Color Index        Byte
'         +---------------+
'      6  |               |       Pixel Aspect Ratio            Byte
'         +---------------+
'
'
'     <Packed Fields>  =      Global Color Table Flag       1 Bit
'                             Color Resolution              3 Bits
'                             Sort Flag                     1 Bit
'                             Size of Global Color Table    3 Bits
'
'     i) Logical Screen Width - Width, in pixels, of the Logical Screen
'        where the images will be rendered in the displaying device.
'
'     ii) Logical Screen Height - Height, in pixels, of the Logical
'         Screen where the images will be rendered in the displaying device.
'
'     iii) Global Color Table Flag - Flag indicating the presence of a
'          Global Color Table; if the flag is set, the Global Color Table will
'          immediately follow the Logical Screen Descriptor. This flag also
'          selects the interpretation of the Background Color Index; if the
'          flag is set, the value of the Background Color Index field should
'          be used as the table index of the background color. (This field is
'          the most significant bit of the byte.)
'
'          Values :    0 -   No Global Color Table follows, the Background
'                            Color Index field is meaningless.
'                      1 -   A Global Color Table will immediately follow, the
'                            Background Color Index field is meaningful.
'
'     iv) Color Resolution - Number of bits per primary color available
'         to the original image, minus 1. This value represents the size of
'         the entire palette from which the colors in the graphic were
'         selected, not the number of colors actually used in the graphic.
'         For example, if the value in this field is 3, then the palette of
'         the original image had 4 bits per primary color available to create
'         the image.  This value should be set to indicate the richness of
'         the original palette, even if not every color from the whole
'         palette is available on the source machine.
'
'     v) Sort Flag - Indicates whether the Global Color Table is sorted.
'        If the flag is set, the Global Color Table is sorted, in order of
'        decreasing importance. Typically, the order would be decreasing
'        frequency, with most frequent color first. This assists a decoder,
'        with fewer available colors, in choosing the best subset of colors;
'        the decoder may use an initial segment of the table to render the
'        graphic.
'
'        Values :    0 -   Not ordered.
'                    1 -   Ordered by decreasing importance, most
'                          important color first.
'
'     vi) Size of Global Color Table - If the Global Color Table Flag is
'         set to 1, the value in this field is used to calculate the number
'         of bytes contained in the Global Color Table. To determine that
'         actual size of the color table, raise 2 to [the value of the field
'         + 1].  Even if there is no Global Color Table specified, set this
'         field according to the above formula so that decoders can choose
'         the best graphics mode to display the stream in.  (This field is
'         made up of the 3 least significant bits of the byte.)
'
'     vii) Background Color Index - Index into the Global Color Table for
'          the Background Color. The Background Color is the color used for
'          those pixels on the screen that are not covered by an image. If the
'          Global Color Table Flag is set to (zero), this field should be zero
'          and should be ignored.
'
'     viii) Pixel Aspect Ratio - Factor used to compute an approximation
'           of the aspect ratio of the pixel in the original image.  If the
'           value of the field is not 0, this approximation of the aspect ratio
'           is computed based on the formula:
'
'           Aspect Ratio = (Pixel Aspect Ratio + 15) / 64
'
'           The Pixel Aspect Ratio is defined to be the quotient of the pixel's
'           width over its height.  The value range in this field allows
'           specification of the widest pixel of 4:1 to the tallest pixel of
'           1:4 in increments of 1/64th.
'
'           Values :        0 -   No aspect ratio information is given.
'                      1..255 -   Value used in the computation.


  TYPE GIF_Header_Type
    signature          AS STRING * 6
    totalx             AS WORD
    totaly             AS WORD
    gctf_cr_sf_sgct    AS BYTE
    background         AS BYTE
    pixel_aspect_ratio AS BYTE
  END TYPE

  DIM GIF_Header AS SHARED GIF_Header_Type


' GLOBAL COLOR TABLE
'
'        This block contains a color table, which is a sequence of
'   bytes representing red-green-blue color triplets. The Global Color Table
'   is used by images without a Local Color Table and by Plain Text
'   Extensions. Its presence is marked by the Global Color Table Flag being
'   set to 1 in the Logical Screen Descriptor; if present, it immediately
'   follows the Logical Screen Descriptor and contains a number of bytes
'   equal to
'                 3 x 2^(Size of Global Color Table+1).
'
'   This block is OPTIONAL; at most one Global Color Table may be present
'   per Data Stream.
'
'       7 6 5 4 3 2 1 0        Field Name                    Type
'      +===============+
'   0  |               |       Red 0                         Byte
'      +-             -+
'   1  |               |       Green 0                       Byte
'      +-             -+
'   2  |               |       Blue 0                        Byte
'      +-             -+
'   3  |               |       Red 1                         Byte
'      +-             -+
'      |               |       Green 1                       Byte
'      +-             -+
'  up  |               |
'      +-   . . . .   -+       ...
'  to  |               |
'      +-             -+
'      |               |       Green 255                     Byte
'      +-             -+
' 767  |               |       Blue 255                      Byte
'      +===============+
'
'   Each pixel value received is displayed according to its
'   closest match with an available color on the display based on this
'   color table.  The color components represent a fractional intensity
'   value from none (0) to full (255).  White would be represented as
'   (255,255,255), black as (0,0,0) and medium yellow as (180,180,0).  For
'   display, if the device supports fewer than 8 bits per color component,
'   the higher order bits of each component are used.  In the creation of
'   a GIF color table entry with hardware supporting fewer than 8 bits per
'   component, the component values for the hardware should be converted
'   to the 8-bit format with the following calculation:
'
'        <map_value> = <component_value>*255/(2^<nbits> -1)
'
'        This assures accurate translation of colors for all displays.  If
'   no Global Color Table is indicated, a default color map is generated
'   internally which maps each incoming color index to a hardware color
'   index.

  REM - gcm$ is used to hold the global color map

' IMAGE DESCRIPTOR
'
'        The Image Descriptor defines the actual placement and extents  of
'   the following image within the space defined in the Screen Descriptor.
'   Also defined are flags to indicate  the  presence  of  a  local  color
'   lookup  map,  and  to  define  the pixel display sequence.  Each Image
'   Descriptor is introduced by an image separator character.  The role of
'   the  Image  Separator is simply to provide a synchronization character
'   to introduce an Image Descriptor.  This is desirable  if  a  GIF  file
'   happens  to contain more than one image.  This character is defined as
'   0x2C hex or ',' (comma).  When this character is  encountered  between
'   images, the Image Descriptor will follow immediately.
'
'              bits
'         7 6 5 4 3 2 1 0  Byte #
'        +---------------+
'        |0 0 1 0 1 1 0 0|  1    ',' - Image separator character
'        +---------------+
'        |               |  2    Start of image in pixels from the
'        +-  Image Left -+       left side of the screen (LSB first)
'        |               |  3
'        +---------------+
'        |               |  4
'        +-  Image Top  -+       Start of image in pixels from the
'        |               |  5    top of the screen (LSB first)
'        +---------------+
'        |               |  6
'        +- Image Width -+       Width of the image in pixels (LSB first)
'        |               |  7
'        +---------------+
'        |               |  8
'        +- Image Height-+       Height of the image in pixels (LSB first)
'        |               |  9
'        +-+-+-+-+-+-----+       M=0 - Use global color map, ignore 'pixel'
'        |M|I|S|0|0|pixel| 10    M=1 - Local color map follows, use 'pixel'
'        +-+-+-+-+-+-----+       I=0 - Image formatted in Sequential order
'                                I=1 - Image formatted in Interlaced order
'                                S=0 - Unsorted local color map
'                                S=1 - Sorted local color map
'                                pixel+1 - # bits per pixel for this image

  TYPE GIF_Image_Descriptor_Type
    image_left   AS WORD
    image_top    AS WORD
    image_width  AS WORD
    image_height AS WORD
    packed1      AS BYTE
  END TYPE

  DIM GIF_Image_Descriptor AS SHARED GIF_Image_Descriptor_Type

'
' GRAPHIC CONTROL EXTENSION
'
'   a. Description. The Graphic Control Extension contains parameters used
'   when processing a graphic rendering block. The scope of this extension is
'   the first graphic rendering block to follow. The extension contains only
'   one data sub-block.
'   This block is OPTIONAL; at most one Graphic Control Extension may precede
'   a graphic rendering block. This is the only limit to the number of
'   Graphic Control Extensions that may be contained in a Data Stream.
'
'   b. Required Version.  89a.
'
'   c. Syntax.
'
'      7 6 5 4 3 2 1 0        Field Name                    Type
'     +---------------+
'  0  |               |       Extension Introducer          Byte
'     +---------------+
'  1  |               |       Graphic Control Label         Byte
'     +---------------+
'
'     +---------------+
'  0  |               |       Block Size                    Byte
'     +---------------+
'  1  |     |     | | |       <Packed Fields>               See below
'     +---------------+
'  2  |               |       Delay Time                    Unsigned
'     +-             -+
'  3  |               |
'     +---------------+
'  4  |               |       Transparent Color Index       Byte
'     +---------------+
'
'     +---------------+
'  0  |               |       Block Terminator              Byte
'     +---------------+
'
'
'      <Packed Fields>  =     Reserved                      3 Bits
'                             Disposal Method               3 Bits
'                             User Input Flag               1 Bit
'                             Transparent Color Flag        1 Bit
'
'        i) Extension Introducer - Identifies the beginning of an extension
'        block. This field contains the fixed value 0x21.
'
'        ii) Graphic Control Label - Identifies the current block as a
'        Graphic Control Extension. This field contains the fixed value
'        0xF9.
'
'        iii) Block Size - Number of bytes in the block, after the Block
'        Size field and up to but not including the Block Terminator.  This
'        field contains the fixed value 4.
'
'        iv) Disposal Method - Indicates the way in which the graphic is to
'        be treated after being displayed.
'
'        Values :    0 -   No disposal specified. The decoder is
'                          not required to take any action.
'                    1 -   Do not dispose. The graphic is to be left
'                          in place.
'                    2 -   Restore to background color. The area used by the
'                          graphic must be restored to the background color.
'                    3 -   Restore to previous. The decoder is required to
'                          restore the area overwritten by the graphic with
'                          what was there prior to rendering the graphic.
'                 4-7 -    To be defined.
'
'        v) User Input Flag - Indicates whether or not user input is
'        expected before continuing. If the flag is set, processing will
'        continue when user input is entered. The nature of the User input
'        is determined by the application (Carriage Return, Mouse Button
'        Click, etc.).
'
'        Values :    0 -   User input is not expected.
'                    1 -   User input is expected.
'
'        When a Delay Time is used and the User Input Flag is set,
'        processing will continue when user input is received or when the
'        delay time expires, whichever occurs first.
'
'        vi) Transparency Flag - Indicates whether a transparency index is
'        given in the Transparent Index field. (This field is the least
'        significant bit of the byte.)
'
'        Values :    0 -   Transparent Index is not given.
'                    1 -   Transparent Index is given.
'
'        vii) Delay Time - If not 0, this field specifies the number of
'        hundredths (1/100) of a second to wait before continuing with the
'        processing of the Data Stream. The clock starts ticking immediately
'        after the graphic is rendered. This field may be used in
'        conjunction with the User Input Flag field.
'
'        viii) Transparency Index - The Transparency Index is such that when
'        encountered, the corresponding pixel of the display device is not
'        modified and processing goes on to the next pixel. The index is
'        present if and only if the Transparency Flag is set to 1.
'
'        ix) Block Terminator - This zero-length data block marks the end of
'        the Graphic Control Extension.
'
'   d. Extensions and Scope. The scope of this Extension is the graphic
'   rendering block that follows it; it is possible for other extensions to
'   be present between this block and its target. This block can modify the
'   Image Descriptor Block and the Plain Text Extension.
'
'   e. Recommendations.
'
'        i) Disposal Method - The mode Restore To Previous is intended to be
'        used in small sections of the graphic; the use of this mode imposes
'        severe demands on the decoder to store the section of the graphic
'        that needs to be saved. For this reason, this mode should be used
'        sparingly.  This mode is not intended to save an entire graphic or
'        large areas of a graphic; when this is the case, the encoder should
'        make every attempt to make the sections of the graphic to be
'        restored be separate graphics in the data stream. In the case where
'        a decoder is not capable of saving an area of a graphic marked as
'        Restore To Previous, it is recommended that a decoder restore to
'        the background color.
'
'        ii) User Input Flag - When the flag is set, indicating that user
'        input is expected, the decoder may sound the bell (0x07) to alert
'        the user that input is being expected.  In the absence of a
'        specified Delay Time, the decoder should wait for user input
'        indefinitely.  It is recommended that the encoder not set the User
'        Input Flag without a Delay Time specified.


  TYPE GIF_gce_type
    block_size  AS BYTE
    packed1     AS BYTE
    delay_time  AS WORD
    trans_color AS BYTE
    block_term  AS BYTE
  END TYPE

  DIM GIF_gce AS SHARED GIF_gce_type
  GIF_gce.block_size = 0?

'
' Application Extension.
'
'      a. Description. The Application Extension contains application-
'      specific information; it conforms with the extension block syntax,
'      as described below, and its block label is 0xFF.
'
'      b. Required Version.  89a.
'
'      c. Syntax.
'
'      7 6 5 4 3 2 1 0        Field Name                    Type
'     +---------------+
'  0  |               |       Extension Introducer          Byte
'     +---------------+
'  1  |               |       Extension Label               Byte
'     +---------------+
'
'     +---------------+
'  0  |               |       Block Size                    Byte
'     +---------------+
'  1  |               |
'     +-             -+
'  2  |               |
'     +-             -+
'  3  |               |       Application Identifier        8 Bytes
'     +-             -+
'  4  |               |
'     +-             -+
'  5  |               |
'     +-             -+
'  6  |               |
'     +-             -+
'  7  |               |
'     +-             -+
'  8  |               |
'     +---------------+
'  9  |               |
'     +-             -+
' 10  |               |       Appl. Authentication Code     3 Bytes
'     +-             -+
' 11  |               |
'     +---------------+
'
'     +===============+
'     |               |
'     |               |       Application Data              Data Sub-blocks
'     |               |
'     |               |
'     +===============+
'
'     +---------------+
'  0  |               |       Block Terminator              Byte
'     +---------------+
'
'        i) Extension Introducer - Defines this block as an extension.
'        This field contains the fixed value 0x21.
'
'        ii) Application Extension Label - Identifies the block as an
'        Application Extension. This field contains the fixed value 0xFF.
'
'        iii) Block Size - Number of bytes in this extension block,
'        following the Block Size field, up to but not including the
'        beginning of the Application Data. This field contains the fixed
'        value 11.
'
'        iv) Application Identifier - Sequence of eight printable ASCII
'        characters used to identify the application owning the
'        Application Extension.
'
'        v) Application Authentication Code - Sequence of three bytes
'        used to authenticate the Application Identifier. An Application
'        program may use an algorithm to compute a binary code that
'        uniquely identifies it as the application owning the
'        Application Extension.
'
'
'      d. Extensions and Scope. This block does not have scope. This block
'      cannot be modified by any extension.
'
'      e. Recommendation. None.
'

' Comment Extension.
'
'      a. Description. The Comment Extension contains textual information which
'      is not part of the actual graphics in the GIF Data Stream. It is suitable
'      for including comments about the graphics, credits, descriptions or any
'      other type of non-control and non-graphic data.  The Comment Extension
'      may be ignored by the decoder, or it may be saved for later processing;
'      under no circumstances should a Comment Extension disrupt or interfere
'      with the processing of the Data Stream.
'
'      This block is OPTIONAL; any number of them may appear in the Data Stream.
'
'      b. Required Version.  89a.
'
'      c. Syntax.
'
'      7 6 5 4 3 2 1 0        Field Name                    Type
'     +---------------+
'  0  |               |       Extension Introducer          Byte
'     +---------------+
'  1  |               |       Comment Label                 Byte
'     +---------------+
'
'     +===============+
'     |               |
'  N  |               |       Comment Data                  Data Sub-blocks
'     |               |
'     +===============+
'
'     +---------------+
'  0  |               |       Block Terminator              Byte
'     +---------------+
'
'            i) Extension Introducer - Identifies the beginning of an extension
'            block. This field contains the fixed value 0x21.
'
'            ii) Comment Label - Identifies the block as a Comment Extension.
'            This field contains the fixed value 0xFE.
'
'            iii) Comment Data - Sequence of sub-blocks, each of size at most
'            255 bytes and at least 1 byte, with the size in a byte preceding
'            the data.  The end of the sequence is marked by the Block
'            Terminator.
'
'            iv) Block Terminator - This zero-length data block marks the end of
'            the Comment Extension.
'
'      d. Extensions and Scope. This block does not have scope. This block
'      cannot be modified by any extension.
'
'      e. Recommendations.
'
'            i) Data - This block is intended for humans.  It should contain
'            text using the 7-bit ASCII character set. This block should
'            not be used to store control information for custom processing.
'
'            ii) Position - This block may appear at any point in the Data
'            Stream at which a block can begin; however, it is recommended that
'            Comment Extensions do not interfere with Control or Data blocks;
'            they should be located at the beginning or at the end of the Data
'            Stream to the extent possible.


ClearScreen:
  CLS
  PRINT "Display .gif files in 256 color modes"
  PRINT
  PRINT "At the 'Filename:' prompt enter:
  PRINT "  a (path and) filename (.GIF extension assumed) to a valid GIF file,"
  PRINT "  <?> to repeat this message or"
  PRINT "  <return> with no data to exit the program."
  PRINT
  PRINT "After entering a valid filename, a delay of three seconds will occur to"
  PRINT " insure that your display card / monitor has had time to change modes."
  PRINT " After that, pressing any key before you hear a BEEP (indicating that the"
  PRINT " image(s) is(are) complete), will interrupt the display and generate an"
  PRINT " immediate BEEP."

  PRINT
  PRINT "The following keys are valid after you hear a BEEP:"
  PRINT "  Return:            Exit to the 'Filename:' prompt"
  PRINT "  Home:              Display the upper left corner of the image(s)"
  PRINT "  PgUp, Up-arrow:    Scroll up 1/2 screen"
  PRINT "  PgDn, Down-arrow:  Scroll down 1/2 screen"
  PRINT "  Left-arrow:        Scroll left 1/2 screen"
  PRINT "  Right-arrow:       Scroll right 1/2 screen"
  PRINT "  End:               Display the lower right corner of the image(s)"
  PRINT "  T (t):             Redisplay using (ignoring) transparency information"
  PRINT "  <any other key>:   if display interrupted, redisplay the image(s)"

Select_File:
  global_transparency = %on
  image_number = 0
  DO
    PRINT
    INPUT "Filename: ", Gif_Filename$
    Gif_Filename$ = LTRIM$ (RTRIM$ (Gif_Filename$) )
    SELECT CASE Gif_Filename$
      CASE ""
        GOTO Endit0
      CASE "?"
        GOTO ClearScreen
    END SELECT
    IF INSTR (Gif_Filename$, ".") = 0 THEN _
     Gif_Filename$ = Gif_Filename$ + ".GIF"

    IF DIR$ (Gif_Filename$) = "" THEN
      PRINT "File not found!"
    ELSE
      Gif_Filenum = FREEFILE
      OPEN Gif_Filename$ FOR BINARY AS #Gif_Filenum
      IF global_dprint = %on THEN
        dprint = %on
        Out_Print = FREEFILE
        OPEN tempdir$ + "\$gifinfo.log" FOR APPEND AS #Out_Print
      ELSE
        dprint = %off
        Out_Print = 0
      END IF
      CALL PrintMessage ("")
      CALL PrintMessage ("GIF file name: " + Gif_Filename$)
      EXIT LOOP
    END IF
  LOOP

  GET #Gif_Filenum, , GIF_Header

  CALL PrintMessage ("")
  CALL PrintMessage ("Header:")
  CALL PrintMessage ("  Signature: " + GIF_Header.signature)
  SELECT CASE GIF_Header.signature
    CASE "GIF87a", "GIF89a"
    CASE ELSE
      CALL PrintMessage ("")
      CALL PrintMessage ("  THIS DOES NOT APPEAR TO BE A VALID GIF FILE" _
       + " SIGNATURE!")
      GOTO EndIt1
  END SELECT

  CALL PrintMessage ("  Logical screen width x height:" _
   + STR$ (GIF_Header.totalx) + " x" + STR$ (GIF_Header.totaly) _
   + " pixels.")

  global_color_table_flag = BIT (GIF_Header.gctf_cr_sf_sgct, 7)
  IF global_color_table_flag = 0 THEN
    CALL PrintMessage ("  Global color table is NOT present")
  ELSE
    CALL PrintMessage ("  Global color table is present")
    CALL PrintMessage ("    background color is set to palette entry" _
     + STR$ (GIF_Header.background) )
  END IF

  color_resolution = ( (GIF_Header.gctf_cr_sf_sgct AND &H70) \ 16) + 1
  CALL PrintMessage ("  Color resolution:" + STR$ (color_resolution) _
   + " bits.")

  global_sort_flag = BIT (GIF_Header.gctf_cr_sf_sgct, 3)
  IF global_sort_flag = 0 THEN a$ = "NOT " ELSE a$ = ""
  CALL PrintMessage ("  Global color table sort flag is " + a$ + "on")

  global_bits_per_pixel = (GIF_Header.gctf_cr_sf_sgct AND 7) + 1
  CALL PrintMessage ("  Global bits / pixel:" _
   + STR$ (global_bits_per_pixel) )

  global_palette_entries = 2 ^ global_bits_per_pixel
  global_palette_length = global_palette_entries * 3
  CALL PrintMessage ("  Global palette entries:" _
   + STR$ (global_palette_entries) + ", length:" _
   + STR$ (global_palette_length) + " bytes")

  IF GIF_Header.signature = "GIF87a" THEN
    IF GIF_Header.pixel_aspect_ratio <> 0 THEN
      CALL PrintMessage ("  Pixel aspect ratio field is not zero in a" _
       + " GIF87a file")
      GOTO Endit1
    END IF
  ELSE
    a$ = "  Pixel aspect ratio:"
    IF GIF_Header.pixel_aspect_ratio = 0 THEN
      CALL PrintMessage (a$ + " not specified")
    ELSE
      CALL PrintMessage (a$ + USING$ ("##.######", _
       (GIF_Header.pixel_aspect_ratio + 15) / 64) )
    END IF
  END IF

  IF global_color_table_flag = 1 THEN
    IF dprint = %on THEN
      PRINT #Out_Print, ""
      PRINT #Out_Print, "Global Color Map:"
    END IF
    bits_per_pixel = global_bits_per_pixel
    GOSUB Get_Color_Map
    saved_global_color_table_flag = 1
    saved_global_bits_per_pixel = global_bits_per_pixel
    gcm$ = Pal$
  END IF

  pass = 1
  save_buffer_loc = SEEK (Gif_Filenum)
  keep_running&& = 0
  Xbase = 0
  Xmax = 0
  Ybase = 0
  Ymax = 0

ProcessImages:
  DO
    GET #Gif_Filenum, , ByteBuffer
    SELECT CASE ByteBuffer
      CASE "!"                        ' Extension Block follows
        GET #Gif_Filenum, , id1?      ' check format ID
        IF id1? = &H0F9? THEN GraphicControlExtension
        IF id1? = &H0FF? THEN
          CALL PrintMessage2 ("")
          GET #Gif_Filenum, , len1?
          IF len1? <> 11 THEN
            a$ = "Application Extension has an invalid length:" _
             + STR$ (len1?)
            IF image_number = 0 THEN
              CALL PrintMessage (a$)
              GOTO Endit1
            ELSE
              display_error$ = a$
              GOTO Endit2
            END IF
          ELSE
            CALL PrintMessage2 ("Application Extension:")
            applid$ = SPACE$ (8)
            GET #Gif_Filenum, , applid$
            CALL PrintMessage2 ("  identifier: " + applid$)
            applcd$ = SPACE$ (3)
            GET #Gif_Filenum, , applcd$
            CALL PrintMessage2 ("  authentication code: " + applcd$)
            DO
              GET #Gif_Filenum, , len1?
              IF len1? = 0 THEN EXIT loop
              GET$ #Gif_Filenum, len1?, a$
              IF (applid$ = "NETSCAPE") _
               AND (applcd$ = "2.0") _
               AND (len1? = 3?) _
               AND (ASC (a$) = 1) THEN
                loopcount?? = CVWRD (MID$ (a$, 2, 2))
                CALL PrintMessage2 ("  loop count:" _
                 + STR$ (loopcount??) )
                keep_running&& = SEEK (Gif_Filenum) + 1
              ELSE
                CALL PrintMessage2 ("  data block:" + STR$ (len1?) _
                 + " bytes:")
                CALL PrintMessage2 (a$)
              END IF
            LOOP
            EXIT SELECT
          END IF
        ELSEIF id1? = &H0FE? THEN
          CALL PrintMessage2 ("")
          CALL PrintMessage2 ("Comment Extension:")
          DO
            GET #Gif_Filenum, , len1?
            IF len1? = 0 THEN EXIT SELECT
            GET$ #Gif_Filenum, len1?, a$
            CALL PrintMessage2 ("  data block: ")
            CALL PrintMessage2 (a$)
          LOOP
        ELSE
          CALL PrintMessage2 ("")
          CALL PrintMessage ("Extension block with ID" + STR$ (id1?) _
           + " bypassed.")
        END IF
        DO
          GET #Gif_Filenum, , len1?
          IF len1? = 0 THEN EXIT LOOP
          GET$ #Gif_Filenum, len1?, a$
        LOOP
      CASE ","                        ' Image Descriptor block follows
        CALL PrintMessage2 ("")
        CALL PrintMessage ("Image descriptor block:")
        EXIT LOOP
      CASE ";"                        ' End of GIF file
        IF keep_running&& > 0 THEN
          dprint = %off
          image_number = 1
          SEEK #Gif_Filenum, keep_running&&
          IF loopcount?? > 0 THEN
            DECR loopcount??
            IF loopcount?? = 0 THEN keep_running&& = 0
          END IF
          GOTO ProcessImages
        END IF
        GOTO Endit2
      CASE ELSE
        a$ = "Bad block ID" + STR$ (ASC (ByteBuffer) ) + " encountered."
        IF image_number = 0 THEN
          CALL PrintMessage (a$)
          GOTO Endit1
        ELSE
          display_error$ = a$
          GOTO Endit2
        END IF
    END SELECT
  LOOP

  GET #GIF_Filenum, , GIF_Image_Descriptor

  Xstart = GIF_Image_Descriptor.image_left
  Ystart = GIF_Image_Descriptor.image_top
  CALL PrintMessage ("  starts at:" + STR$ (Xstart) + " ," + STR$ (Ystart) )

  Xlength = GIF_Image_Descriptor.image_width
  Ylength = GIF_Image_Descriptor.image_height
  CALL PrintMessage ("  size is:" + STR$ (Xlength) + " x" + STR$ (Ylength) )

  Xend = Xlength + Xstart - 1
  Yend = Ylength + Ystart - 1
  IF pass = 1 THEN
    IF Xend > Xmax THEN Xmax = Xend
    IF Yend > Ymax THEN Ymax = Yend
  END IF

  local_color_map = BIT (GIF_Image_Descriptor.packed1, 7)
  IF local_color_map = 1 THEN
    bits_per_pixel = (GIF_Image_Descriptor.packed1 AND 7) + 1
    CALL PrintMessage ("  local color map:" + STR$ (bits_per_pixel) _
     + " bits/pixel")
    GOSUB Get_Color_Map
    new_palette = %yes
    new_palette_type = %local
  ELSEIF saved_global_color_table_flag = 1 THEN
    bits_per_pixel = saved_global_bits_per_pixel
    palette_entries = 2 ^ bits_per_pixel
    palette_length = palette_entries * 3
    Pal$ = gcm$
    new_palette = %no
    new_palette_type = %global
  ELSE
    new_palette = %no
  END IF

  interlaced_image = BIT (GIF_Image_Descriptor.packed1, 6)
  IF interlaced_image = 1 THEN
    CALL PrintMessage ("  interlaced flag is on")
    y_start_offset = 0
    y_incr = 8
  ELSE
    y_incr = 1
  END IF

  local_sort_flag = BIT (GIF_Image_Descriptor.packed1, 5)
  IF local_sort_flag = 0 THEN a$ = "NOT " ELSE a$ = ""
  CALL PrintMessage ("  sort flag is " + a$ + "on")

  GET #Gif_Filenum, , ByteBuffer
  CodeSize = ASC(ByteBuffer)
  ClearCode = Powers2(CodeSize)
  EOFCode = ClearCode + 1
  FirstFree = ClearCode + 2
  FreeCode = FirstFree
  INCR CodeSize
  InitCodeSize = CodeSize
  Maxcode = MaxCodes(CodeSize)
  Bitmask = CodeMask(bits_per_pixel)

  GET #Gif_Filenum, , BlockLength?
  GET$ #Gif_Filenum, BlockLength?, HoldBlock$
  Bitsin = 7
  Num = 0
  DECR Xstart, Xbase
  X = Xstart
  DECR Ystart, Ybase
  Y = Ystart
  DECR Xend, Xbase
  DECR Yend, Ybase

  IF image_number = 0 THEN

    IF lastvideomode = 0 THEN
      video_mode_1?? = ValidVideoMode(0).mode
      PRINT
      PRINT "Image will be displayed in video mode "; _
       HEX$ (video_mode_1??); "h"
      PRINT
      CALL PressAnyKey
    ELSE
      DO
        default1 = -1
        PRINT
        PRINT "Select from the following video modes:"
        FOR i = 0 TO lastvideomode
          PRINT STR$ (i); ": "; HEX$ (ValidVideoMode(i).mode); " -"; _
           ValidVideoMode(i).Xresolution; "x"; ValidVideoMode(i).Yresolution
          IF default1 = -1 THEN
            IF Xend + 1 = ValidVideoMode(i).Xresolution THEN
              IF Yend + 1 = ValidVideoMode(i).Yresolution THEN
                default1 = i
                ITERATE FOR
              END IF
            END IF
            IF ValidVideoMode(i).mode >= &H0101 THEN
              IF Xend < ValidVideoMode(i).Xresolution THEN
                IF Yend < ValidVideoMode(i).Yresolution THEN
                  default1 = i
                  ITERATE FOR
                END IF
              END IF
            ELSEIF i = lastvideomode THEN
              default1 = i
            END IF
          END IF
        NEXT i
        PRINT "Enter your choice (0-"; LTRIM$ (STR$ (lastvideomode) ); _
         ") [default ="; STR$ (default1);
        INPUT "]: ", a$
        IF a$ = "" THEN
          video_mode_1?? = ValidVideoMode(default1).mode
          EXIT LOOP
        ELSE
          i = VAL (a$)
          IF (i < 0) OR (i > lastvideomode) THEN
            PRINT "Invalid choice"
          ELSE
            video_mode_1?? = ValidVideoMode(i).mode
            EXIT LOOP
          END IF
        END IF
      LOOP
    END IF

    i = Svga_F01?? (video_mode_1??, vesa1)

    CALL SetImageMode (%on)
    screen_palette_type = %default
    DELAY 3
    WHILE INKEY$ <> "" : WEND

  END IF

  IF (new_palette = %yes) OR (new_palette_type <> screen_palette_type) THEN
    IF palette_entries > 0 THEN
      REG %AX, &H1012                 ' set the palette
      REG %BX, 0
      REG %CX, palette_entries
      REG %DX, STRPTR(Pal$)
      REG %ES, STRSEG(Pal$)
      CALL INTERRUPT &H10
    END IF
    screen_palette_type = new_palette_type
  END IF

  INCR image_number

  DO                                  ' LZW decompression loop
    Code = ReadCode(CodeSize)
    IF Code = EOFCode THEN EXIT LOOP
    IF Code = ClearCode THEN
      CodeSize = InitCodeSize
      Maxcode = MaxCodes(CodeSize)
      FreeCode = FirstFree
      Code = ReadCode(CodeSize)
      OldCode = Code
      FinChar = Code
      PlotPixel FinChar
    ELSE
      InCode = Code
      IF Code <= Bitmask THEN
        FinChar = Code
        PlotPixel FinChar
      ELSE
        IF Code >= FreeCode THEN
          Code = OldCode
          Outcode(0) = FinChar
          OutCount = 1
        ELSE
          OutCount = 0
        END IF
        WHILE Code > Bitmask
          OutCode(OutCount) = Suffix(Code)
          INCR OutCount
          Code = Prefix(Code)
        WEND
        FinChar = Code
        Outcode(OutCount) = FinChar
        FOR I = OutCount TO 0 STEP -1
          PlotPixel Outcode(I)
        NEXT
      END IF
      Prefix(FreeCode) = OldCode
      Suffix(FreeCode) = FinChar
      OldCode = InCode
      INCR FreeCode
      IF FreeCode >= Maxcode THEN
        IF CodeSize < 12 THEN
          INCR CodeSize
          INCR Maxcode, Maxcode
        END IF
      END IF
    END IF
    Akey$ = INKEY$
  LOOP UNTIL Akey$ <> ""

  IF Akey$ = "" THEN
    GET #Gif_Filenum, , zero1?
    IF zero1? <> 0? THEN
      display_error$ = "Missing a zero byte after an image display block."
      GOTO Endit2
    END IF

    IF GIF_gce.block_size <> 0? THEN
      GIF_gce.block_size = 0?

      IF GIF_gce.delay_time > 0 THEN
        timer1! = TIMER
        DO WHILE NOT INSTAT
          timer2! = TIMER
          IF timer2! < timer1! THEN INCR timer2!, 86400!
        LOOP UNTIL timer2! > (timer1! + (GIF_gce.delay_time * .01) )
      END IF

      IF INSTAT THEN Akey$ = INKEY$ : GOTO Endit2
      IF gce_disposal_method? >= 2? THEN    ' clear to background color
        Xstart = MAX% (Xstart, 0)
        Xend = MIN% (Xend, screen_Xmax)
        IF Xstart <= Xend THEN
          Ystart = MAX% (Ystart, 0)
          Yend = MIN% (Yend, screen_Ymax)
          IF Ystart <= Yend THEN CALL ClearBG
        END IF
      END IF
    END IF
    GOTO ProcessImages
  END IF

Endit2:
  BEEP
  WHILE NOT INSTAT : WEND
  a$ = INKEY$
  IF LEN (a$) = 1 THEN
    ikey = ASC (a$)
  ELSE
    ikey = - ASC (RIGHT$ (a$, 1) )
  END IF
  SELECT CASE ikey
    CASE 13                         ' return
      GOTO Endit2a
    CASE 84                         ' T: redisplay using transparency
      global_transparency = %on
    CASE 116                        ' t: redisplay ignoring transparency
      global_transparency = %off
    CASE -71                        ' home
      IF (Xbase = 0 AND Ybase = 0) THEN IF Akey$="" THEN Endit2
      Xbase = 0
      Ybase = 0
    CASE -72, -73                   ' Up arrow, PgUp
      IF Ybase = 0 THEN
        IF Akey$ = "" THEN Endit2 ELSE EXIT SELECT
      END IF
      Ybase = max% (Ybase - (screen_Ymax + 1) \ 2, 0)
    CASE -75                        ' Left arrow
      IF Xbase = 0 THEN
        IF Akey$ = "" THEN Endit2 ELSE EXIT SELECT
      END IF
      Xbase = max% (Xbase - (screen_Xmax + 1) \ 2, 0)
    CASE -77                        ' Right arrow
      IF (Xbase + screen_Xmax + 1) > Xmax THEN
        IF Akey$ = "" THEN Endit2 ELSE EXIT SELECT
      END IF
      Xbase = min% (Xbase + (screen_Xmax + 1) \ 2, Xmax - screen_Xmax)
    CASE -79                        ' end
      IF (Xbase + screen_Xmax + 1) > Xmax THEN
        IF (Ybase + screen_Ymax + 1) > Ymax THEN
          IF Akey$ = "" THEN Endit2 ELSE EXIT SELECT
        END IF
      END IF
      IF (Xbase + screen_Xmax + 1) <= Xmax THEN Xbase = Xmax - screen_Xmax
      IF (Ybase + screen_Ymax + 1) <= Ymax THEN Ybase = Ymax - screen_Ymax
    CASE -80, -81                   ' Down arrow, PgDn
      IF (Ybase + screen_Ymax + 1) > Ymax THEN
        IF Akey$ = "" THEN Endit2 ELSE EXIT SELECT
      END IF
      Ybase = min% (Ybase + (screen_Ymax + 1) \ 2, Ymax - screen_Ymax)
    CASE ELSE
      IF Akey$ = "" THEN Endit2
  END SELECT
  Akey$ = ""
  pass = 2
  dprint = %no
  SEEK #Gif_Filenum, save_buffer_loc
  Xstart = 0
  Xend = screen_Xmax
  Ystart = 0
  Yend = screen_Ymax
  CALL ClearBG
  GOTO ProcessImages

Endit2a:
  Akey$ = ""
  IF palette_entries > 0 THEN
    DO                                ' fade the image
      i2 = 0
      FOR i = 1 TO palette_length STEP 96
        j2 = 0
        FOR j = 0 TO MIN% (95, palette_length - i)
          j1 = ASC (MID$ (Pal$, i + j, 1) )
          IF j1 > 0 THEN
            DECR j1
            INCR j2
            MID$ (Pal$, i + j, 1) = CHR$ (j1)
          END IF
        NEXT j
        IF j2 > 0 THEN
          INCR i2, j2
          WAIT &H3da, 8               ' wait until out of vertical retrace
          WAIT &H3da, 8, 8            ' wait until in vertical retrace
          REG %AX, &H1012             ' set the palette
          REG %BX, i \ 3
          REG %CX, MIN% (96, palette_length - i + 1) \ 3
          REG %DX, STRPTR(Pal$) + i - 1
          REG %ES, STRSEG(Pal$)
          CALL INTERRUPT &H10
        END IF
      NEXT i
    LOOP UNTIL i2 = 0
  END IF

  CALL SetImageMode (%off)            ' back to text mode

Endit1:
  CLOSE Gif_Filenum
  IF Out_Print > 0 THEN
    PRINT #Out_Print, ""
    PRINT #Out_Print, REPEAT$ (39, " -")
    CLOSE Out_Print
    Out_Print = 0
  END IF

Endit0:
  PRINT display_error$

  IF Gif_Filename$ = "" THEN
    PRINT "EOJ"
  ELSE
    display_error$ = ""
    GOTO Select_File
  END IF

  END

'FileNotFound:
'  i = 64
'  RESUME NEXT

GraphicControlExtension:
  CALL PrintMessage ("")
  CALL PrintMessage ("Graphic Control Extension:")
  GET #Gif_Filenum, , GIF_gce

  IF GIF_gce.block_size <> 4? THEN
    a$ = "Graphic Control Extension block size is not equal to 4."
    IF image_number = 0 THEN
      CALL PrintMessage ("  " + a$)
      GOTO Endit1
    ELSE
      display_error$ = a$
      GOTO Endit2
    END IF
  END IF

  IF GIF_gce.block_term <> 0? THEN
    a$ = "Graphic Control Extension block terminator is not zero."
    IF image_number = 0 THEN
      CALL PrintMessage ("  " + a$)
      GOTO Endit1
    ELSE
      display_error$ = a$
      GOTO Endit2
    END IF
  END IF

  gce_disposal_method? = GIF_gce.packed1 AND &B00011100?
  SHIFT RIGHT gce_disposal_method?, 2
  IF gce_disposal_method? > 3? THEN
    CALL PrintMessage ("  invalid disposal method:" _
     + STR$ (gce_disposal_method?) + " - changed to 0.")
    gce_disposal_method? = 0?
  ELSE
    CALL PrintMessage2 ("  disposal method:" + STR$ (gce_disposal_method?) )
  END IF

  CALL PrintMessage2 ("  delay time:" + USING$ ("#####.##", _
   GIF_gce.delay_time / 100) + " seconds")

  gce_user_input_flag? = BIT (GIF_gce.packed1, 1)
  IF gce_user_input_flag? = 1? THEN
    a$ = ""
    IF GIF_gce.delay_time = 0 THEN GIF_gce.delay_time = 500
  ELSE
    a$ = "NOT "
  END IF
  CALL PrintMessage2 ("  user input flag is " + a$ + "set")

  gce_transparent_color_flag? = BIT (GIF_gce.packed1, 0)
  IF gce_transparent_color_flag? = 1? THEN
    CALL PrintMessage2 ("  transparent color is set to palette entry" _
     + STR$(GIF_gce.trans_color) )
    IF global_transparency = %off THEN gce_transparent_color_flag? = 0?
  ELSE
    CALL PrintMessage2 ("  transparent color flag is NOT set")
  END IF

  GOTO ProcessImages

Get_Color_Map:
  palette_entries = 2 ^ bits_per_pixel
  palette_length = palette_entries * 3
  GET$ #Gif_Filenum, palette_length, Pal$
  IF dprint = %on THEN
    PRINT #Out_Print, "  palette entries:" + STR$ (palette_entries) + ":";
    FOR i = 1 TO palette_length STEP 3
      IF (i MOD 15) = 1 THEN
        PRINT #Out_Print, ""
        a$ = SPACE$ (4) + RIGHT$ (" " + STR$ (i \ 3), 3) + ":   "
      ELSE
        a$ = SPACE$ (3)
      END IF
      PRINT #Out_Print, a$ _
       + RIGHT$ ("  " + STR$ (ASC (MID$ (Pal$, i, 1) ) ), 3) + "," _
       + RIGHT$ ("  " + STR$ (ASC (MID$ (Pal$, i+1, 1) ) ), 3) + "," _
       + RIGHT$ ("  " + STR$ (ASC (MID$ (Pal$, i+2, 1) ) ), 3);
    NEXT i
    PRINT #Out_Print, ""
  END IF
  FOR i = 1 TO palette_length
    tmp? = ASC (MID$ (Pal$, i, 1) )
    SHIFT RIGHT tmp?, 2
    MID$ (Pal$, i, 1) = CHR$ (tmp?)
  NEXT i
  RETURN

FUNCTION ChkVideoModes% (mode AS WORD) LOCAL PRIVATE
  IF Svga_F01?? (mode, vesa1) = 0 THEN
    IF BIT (vesa1.ModeAttributes, 0) = 0 THEN
      PRINT "not supported in hardware"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF BIT (vesa1.ModeAttributes, 4) = 0 THEN
      PRINT "not a graphics mode"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF BIT (vesa1.WinAAttributes, 0) = 1 THEN
      IF vesa1.WinASegment > 0 THEN
        IF BIT (vesa1.WinAAttributes, 1) = 1 THEN
          win_read? = 0?
          win_read_seg?? = vesa1.WinASegment
        END IF
        IF BIT (vesa1.WinAAttributes, 2) = 1 THEN
          win_write? = 0?
          win_write_seg?? = vesa1.WinASegment
        END IF
      END IF
    END IF
    IF BIT (vesa1.WinBAttributes, 0) = 1 THEN
      IF vesa1.WinBSegment > 0 THEN
        IF BIT (vesa1.WinBAttributes, 1) = 1 THEN
          win_read? = 1?
          win_read_seg?? = vesa1.WinBSegment
        END IF
        IF BIT (vesa1.WinBAttributes, 2) = 1 THEN
          win_write? = 1?
          win_write_seg?? = vesa1.WinBSegment
        END IF
      END IF
    END IF
    IF win_read? = 255 THEN
      PRINT "has no read window"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF win_write? = 255 THEN
      PRINT "no write window"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF vesa1.WinGranularity = 0 THEN
      PRINT "window granularity is zero"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF vesa1.WinSize = 0 THEN
      PRINT "window size is zero"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    WindowSize& = vesa1.WinSize * 1024&
    IF vesa1.WinGranularity > vesa1.WinSize THEN
      PRINT "window granularity > window size"
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF vesa1.BitsPerPixel <> 8 THEN
      PRINT "bits per pixel not 8 (256 color):"; vesa1.BitsPerPixel
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF vesa1.MemoryModel <> 4 THEN
      PRINT "memory model type not = 4 (packed pixels): "; vesa1.MemoryModel
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    IF vesa1.BytesPerScanLine < vesa1.XResolution THEN
      PRINT "bytes per scan line ("; _
       LTRIM$ (STR$ (vesa1.BytesPerScanLine) ); ") < X-Resolution ("; _
       LTRIM$ (STR$ (vesa1.XResolution) )
      FUNCTION = -1
      EXIT FUNCTION
    END IF
    FUNCTION = 0
  ELSE
    PRINT "not supported"
    FUNCTION = -1
  END IF
END FUNCTION

SUB ClearBG LOCAL PRIVATE
  SHARED video_mode_1??, BytesPerScanLine&
  bkg$ = STRING$ (Xend + 1 - Xstart, GIF_Header.background)
  IF video_mode_1?? = &H0013 THEN
    DEF SEG = &HA000
    FOR i = Ystart TO Yend
      POKE$ (screen_Xmax + 1) * i + Xstart, bkg$
    NEXT i
    DEF SEG
  ELSE
    FOR i = Ystart TO Yend
      offset& = i * BytesPerScanLine& + Xstart
      IF (offset& < cur_win_base&) OR (offset& >= nxt_win_base&) THEN _
       CALL SetSvgaWin (offset&)
      IF (offset& + LEN (bkg$)) > nxt_win_base& THEN
        DEF SEG = win_write_seg??
        POKE$ offset& - cur_win_base&, _
         MID$ (bkg$, 1, nxt_win_base& - offset&)
        DEF SEG
        CALL SetSvgaWin (nxt_win_base&)
        DEF SEG = win_write_seg??
        POKE$ 0, MID$ (bkg$, 1, offset& + LEN (bkg$) - cur_win_base&)
        DEF SEG
      ELSE
        DEF SEG = win_write_seg??
        POKE$ offset& - cur_win_base&, bkg$
        DEF SEG
      END IF
    NEXT i
  END IF
END SUB

'This subprogram gets one bit from the data stream.
FUNCTION Getbit STATIC
  SHARED Bitsin, BlockLength?, Num, Gif_Filenum, HoldBlock$
  INCR Bitsin
  IF Bitsin > 7 THEN
    Bitsin = 0
    INCR Num
    IF Num > BlockLength? THEN
      GET #Gif_Filenum, , BlockLength?
      GET$ #Gif_Filenum, BlockLength?, HoldBlock$
      Num = 1
    END IF
    TempByte? = ASC (Mid$ (HoldBlock$, Num, 1) )
  END IF
  GetBit = BIT (TempByte?, Bitsin)
END FUNCTION

'This subprogram plots one pixel on the display.
SUB PlotPixel (BYVAL A) STATIC
  SHARED gce_transparent_color_flag?, video_mode_1??, BytesPerScanLine&
  IF GIF_gce.block_size <> 0 THEN
    IF gce_transparent_color_flag? = 1? THEN
      IF GIF_gce.trans_color = A THEN PlotPixel2
    END IF
  END IF
  IF X >= 0 THEN
    IF X <= screen_Xmax THEN
      IF Y >= 0 THEN
        IF Y <= screen_Ymax THEN
          IF video_mode_1?? = &H0013 THEN
            DEF SEG = &H0a000
            POKE Y * (screen_Xmax + 1) + X, A
            DEF SEG
          ELSE
            offset& = Y * BytesPerScanLine& + X
            IF (offset& < cur_win_base&) OR (offset& >= nxt_win_base&) _
             THEN CALL SetSvgaWin (offset&)
            DEF SEG = win_write_seg??
            POKE offset& - cur_win_base&, A
            DEF SEG
          END IF
        END IF
      END IF
    END IF
  END IF

PlotPixel2:
  INCR X
  IF X > Xend THEN
    X = Xstart
    INCR Y, y_incr
    IF Y > Yend THEN
      IF interlaced_image = 1 THEN
        SELECT CASE y_start_offset
          case 0
            y_start_offset = 4
          case 4
            y_start_offset = 2
            y_incr = 4
          case 2
            y_start_offset = 1
            y_incr = 2
          case 1
            EXIT IF
        END SELECT
        Y = Ystart + y_start_offset
      END IF
    END IF
  END IF
END SUB

SUB PressAnyKey LOCAL PRIVATE
  WHILE INKEY$ <> "" : WEND
  PRINT "Press any key to continue";
  LOCATE , , 1
  WHILE INKEY$ = "" : WEND
  LOCATE , , 0
  PRINT
END SUB

SUB PrintMessage (msg1$) LOCAL PRIVATE
  SHARED dprint, image_number, Out_Print
  IF dprint = %on THEN PRINT #Out_Print, msg1$
  IF image_number = 0 THEN PRINT msg1$
END SUB

SUB PrintMessage2 (msg1$) LOCAL PRIVATE
  SHARED dprint, Out_Print
  IF dprint = %on THEN PRINT #Out_Print, msg1$
END SUB

'This subprogram reads one LZW code from the data stream.
FUNCTION ReadCode (CodeSize)
  Code = 0
  FOR Aa = 0 TO CodeSize - 1
    IF GetBit = 1 THEN BIT SET Code, Aa
  NEXT
  ReadCode = Code
END FUNCTION

SUB SetImageMode (BYVAL Bool) LOCAL PRIVATE
  SHARED BytesPerScanLine&, video_mode_0??, video_mode_1??
  IF video_mode_1?? = &H0013 THEN
    IF Bool THEN
      screen_Xmax = 319
      screen_Ymax = 199
      REG %AX, &H0013
    ELSE
      REG %AX, video_mode_0??
    END IF
    CALL INTERRUPT &H10
  ELSE
    IF Bool THEN
      BytesPerScanLine& = vesa1.BytesPerScanLine
      screen_Xmax = vesa1.Xresolution - 1
      screen_Ymax = vesa1.Yresolution - 1
      i = Svga_F02 (video_mode_1??)
      CALL SetSvgaWin (0&)
    ELSE
      i = Svga_F02 (video_mode_0??)
    END IF
  END IF
END SUB

SUB SetSvgaWin (BYVAL offset&) LOCAL PRIVATE
  setwin% = INT (offset& / WindowSize&) _
   * (vesa1.WinSize \ vesa1.WinGranularity)
  i = Svga_F05_00 (win_write?, setwin%)
  cur_win_base& = setwin% * WindowSize&
  nxt_win_base& = cur_win_base& + WindowSize&
END SUB
